CREATE TABLE em_sys_client_version_right (
  id varchar(32) NOT NULL PRIMARY KEY,
  version_id varchar(32) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER DEFAULT NULL,
  status  NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_sys_client_version_right is '系统客户端版本可见范围表'
;
COMMENT ON COLUMN em_sys_client_version_right.id IS 'ID'
;
COMMENT ON COLUMN em_sys_client_version_right.version_id IS '版本ID，版本数据主键ID'
;
COMMENT ON COLUMN em_sys_client_version_right.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sys_client_version_right.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sys_client_version_right.status IS '状态'
;
COMMENT ON COLUMN em_sys_client_version_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_client_version_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_client_version_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_client_version_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_client_version_right.tenant_id IS '企业租户ID'
;