CREATE TABLE em_msg_group_dept (
  id varchar(32) PRIMARY KEY,
  group_id varchar(50) DEFAULT NULL,
  dept_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
) 
;
CREATE INDEX em_msg_group_dept_ctime ON em_msg_group_dept(create_time)
;
CREATE INDEX em_msg_group_dept_did ON em_msg_group_dept(dept_id)
;
CREATE INDEX em_msg_group_dept_gid ON em_msg_group_dept(group_id)
;
COMMENT ON TABLE em_msg_group_dept is '部门群数据表'
;
COMMENT ON COLUMN em_msg_group_dept.id IS 'ID'
;
COMMENT ON COLUMN em_msg_group_dept.group_id IS '群组ID'
;
COMMENT ON COLUMN em_msg_group_dept.dept_id IS '部门ID'
;
COMMENT ON COLUMN em_msg_group_dept.status IS '状态'
;
COMMENT ON COLUMN em_msg_group_dept.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group_dept.create_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_dept.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group_dept.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_dept.tenant_id IS '企业租户ID'
;

CREATE TABLE em_msg_group_dept_user (
  id varchar(32) PRIMARY KEY ,
  group_id varchar(50) DEFAULT NULL,
  dept_id varchar(32) DEFAULT NULL,
  user_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE INDEX em_msg_group_dept_user_ctime ON em_msg_group_dept_user(create_time)
;
CREATE INDEX em_msg_group_dept_user_did ON em_msg_group_dept_user(dept_id)
;
CREATE INDEX em_msg_group_dept_user_gid ON em_msg_group_dept_user(group_id)
;
CREATE INDEX em_msg_group_dept_user_uid ON em_msg_group_dept_user(user_id)
;
COMMENT ON TABLE em_msg_group_dept_user is '部门群成员表'
;
COMMENT ON COLUMN em_msg_group_dept_user.id IS 'ID'
;
COMMENT ON COLUMN em_msg_group_dept_user.group_id IS '群组ID'
;
COMMENT ON COLUMN em_msg_group_dept_user.dept_id IS '部门ID'
;
COMMENT ON COLUMN em_msg_group_dept_user.user_id IS '人员ID'
;
COMMENT ON COLUMN em_msg_group_dept_user.status IS '状态'
;
COMMENT ON COLUMN em_msg_group_dept_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group_dept_user.create_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_dept_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group_dept_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_dept_user.tenant_id IS '企业租户ID'
;