ALTER TABLE em_msg_ding RENAME TO em_msg_ding_bak
;
CREATE TABLE em_msg_ding (
  id varchar(32) NOT NULL PRIMARY KEY,
  send_user_id varchar(32) DEFAULT NULL,
  touserids CLOB,
  messageid varchar(50) DEFAULT NULL,
  msg_content varchar(1000) DEFAULT NULL,
  msg_type NUMBER(4,0) DEFAULT '1',
  send_type NUMBER(4,0) DEFAULT '1',
  send_time TIMESTAMP DEFAULT NULL,
  send_result NUMBER(4,0) DEFAULT '1',
  msg_ding_id varchar(50) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_msg_ding IS '必达消息数据表'
;
COMMENT ON COLUMN em_msg_ding.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_ding.send_user_id IS '发送人id'
;
COMMENT ON COLUMN em_msg_ding.touserids IS '接收人员id，多个用逗号分隔'
;
COMMENT ON COLUMN em_msg_ding.messageid IS '消息转必达id'
;
COMMENT ON COLUMN em_msg_ding.msg_content IS '消息内容'
;
COMMENT ON COLUMN em_msg_ding.msg_type IS '消息类型：1-应用内，2-短信，3-电话'
;
COMMENT ON COLUMN em_msg_ding.send_type IS '发送类型：1-立即发送，2-定时发送'
;
COMMENT ON COLUMN em_msg_ding.send_time IS '定时发送的时间，格式为YYYY-MM-DD HH:MM:ss'
;
COMMENT ON COLUMN em_msg_ding.send_result IS '发送结果：1-发生成功，2-等待发送，3-发送失败'
;
COMMENT ON COLUMN em_msg_ding.msg_ding_id IS '对应消息服务中的数据ID'
;
COMMENT ON COLUMN em_msg_ding.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_msg_ding.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_ding.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_ding.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_ding.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_ding.tenant_id IS '企业租户ID'
;
CREATE INDEX em_ding_tenant_id_index ON em_msg_ding(tenant_id)
;
CREATE INDEX em_ding_create_time_index ON em_msg_ding(create_time)
;