CREATE TABLE em_agent_base_msgmenu (
  id             varchar(32)  NOT NULL PRIMARY KEY,
  agent_base_id  varchar(32)  NOT NULL,
  issys          NUMBER(4, 0) DEFAULT 0,
  msgtype        varchar(500) DEFAULT NULL,
  ismultiple 	 NUMBER(4, 0) DEFAULT 0,
  open_type 	 NUMBER(4, 0) DEFAULT 1,
  win_width  	 NUMBER(4, 0)  DEFAULT NULL,
  win_height 	 NUMBER(4, 0)  DEFAULT NULL,
  showorder 	 NUMBER(4, 0)  DEFAULT NULL
)
;
COMMENT ON TABLE em_agent_base_msgmenu IS '消息菜单配置信息表'
;
CREATE INDEX em_agent_msgmenu_baseid_index ON em_agent_base_msgmenu(agent_base_id)
;
COMMENT ON COLUMN em_agent_base_msgmenu.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_base_msgmenu.agent_base_id IS '应用ID'
;
COMMENT ON COLUMN em_agent_base_msgmenu.issys IS '是否系统默认,系统默认的菜单按钮不允许修改'
;
COMMENT ON COLUMN em_agent_base_msgmenu.msgtype IS '适用消息类型：1-文本消息，2-图片消息，3-表情消息，4-语音消息，5-位置消息，6-文件，适用于多个类型时用逗号分隔表示'
;
COMMENT ON COLUMN em_agent_base_msgmenu.ismultiple IS '是否支持消息多选，1-是，0-否'
;
COMMENT ON COLUMN em_agent_base_msgmenu.open_type IS '菜单点击打开目标方式，1-窗口，2-浏览器'
;
COMMENT ON COLUMN em_agent_base_msgmenu.win_width IS '如果是打开窗口，窗口宽带，单位像素px'
;
COMMENT ON COLUMN em_agent_base_msgmenu.win_height IS '如果是打开窗口，窗口高度，单位像素px'
;
COMMENT ON COLUMN em_agent_base_msgmenu.showorder IS '显示顺序'
;