CREATE TABLE em_otp_userinfo (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  sn varchar(255) DEFAULT NULL,
  code varchar(255) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_otp_userinfo IS 'OTP用户信息'
;
COMMENT ON COLUMN em_otp_userinfo.id IS '主键'
;
COMMENT ON COLUMN em_otp_userinfo.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_otp_userinfo.sn IS '序列号'
;
COMMENT ON COLUMN em_otp_userinfo.code IS '激活码'
;
COMMENT ON COLUMN em_otp_userinfo.status IS '状态'
;
COMMENT ON COLUMN em_otp_userinfo.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_otp_userinfo.create_time IS '创建时间'
;
COMMENT ON COLUMN em_otp_userinfo.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_otp_userinfo.update_time IS '最后修改时间'
;
COMMENT ON COLUMN em_otp_userinfo.tenant_id IS '租户ID'
;
CREATE INDEX em_otp_userinfo_bui_idx ON em_otp_userinfo(base_user_id)
;
CREATE TABLE em_otp_verify_record (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  token varchar(255) DEFAULT NULL,
  success NUMBER(4,0) DEFAULT NULL,
  verify_msg CLOB,
  ip varchar(255),
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_otp_verify_record IS 'OTP验证记录'
;
COMMENT ON COLUMN em_otp_verify_record.id IS '主键'
;
COMMENT ON COLUMN em_otp_verify_record.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_otp_verify_record.token IS '令牌'
;
COMMENT ON COLUMN em_otp_verify_record.success IS '是否验证成功：0-失败、1-成功'
;
COMMENT ON COLUMN em_otp_verify_record.verify_msg IS '验证信息'
;
COMMENT ON COLUMN em_otp_verify_record.ip IS 'ip地址'
;
COMMENT ON COLUMN em_otp_verify_record.status IS '状态'
;
COMMENT ON COLUMN em_otp_verify_record.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_otp_verify_record.create_time IS '创建时间'
;
COMMENT ON COLUMN em_otp_verify_record.tenant_id IS '租户ID'
;
CREATE INDEX em_otp_verify_record_ct_idx ON em_otp_verify_record(create_time)
;