CREATE TABLE em_cp_external_contact (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  external_user_id varchar(32) DEFAULT NULL,
  name varchar(255) DEFAULT NULL,
  avatar varchar(255) DEFAULT NULL,
  external_contact_type NUMBER(4,0) DEFAULT NULL,
  gender NUMBER(4,0) DEFAULT NULL,
  union_id varchar(255) DEFAULT NULL,
  position varchar(255) DEFAULT NULL,
  corp_name varchar(255) DEFAULT NULL,
  corp_full_name varchar(255) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_external_contact IS '外部联系人信息'
;
COMMENT ON COLUMN em_cp_external_contact.id IS '主键'
;
COMMENT ON COLUMN em_cp_external_contact.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_external_contact.external_user_id IS '外部联系人的userid'
;
COMMENT ON COLUMN em_cp_external_contact.name IS '外部联系人的名称'
;
COMMENT ON COLUMN em_cp_external_contact.avatar IS '外部联系人头像，第三方不可获取'
;
COMMENT ON COLUMN em_cp_external_contact.external_contact_type IS '外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户'
;
COMMENT ON COLUMN em_cp_external_contact.gender IS '外部联系人性别 0-未知 1-男性 2-女性'
;
COMMENT ON COLUMN em_cp_external_contact.union_id IS '外部联系人在微信开放平台的唯一身份标识'
;
COMMENT ON COLUMN em_cp_external_contact.position IS '外部联系人的职位'
;
COMMENT ON COLUMN em_cp_external_contact.corp_name IS '外部联系人所在企业的简称'
;
COMMENT ON COLUMN em_cp_external_contact.corp_full_name IS '外部联系人所在企业的主体名称'
;
COMMENT ON COLUMN em_cp_external_contact.status IS '状态'
;
COMMENT ON COLUMN em_cp_external_contact.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_external_contact.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_external_contact.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_external_contact.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_external_contact.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_external_contact_eui_idx ON em_cp_external_contact(external_user_id)
;
CREATE INDEX em_cp_external_contact_ct_idx ON em_cp_external_contact(create_time)
;
CREATE INDEX em_cp_external_contact_ti_idx ON em_cp_external_contact(tenant_id)
;
CREATE TABLE em_cp_user_external_contact (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  open_user_id varchar(32) DEFAULT NULL,
  external_user_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_external_contact IS '企业内部人员于外部联系人关联关系'
;
COMMENT ON COLUMN em_cp_user_external_contact.id IS '主键'
;
COMMENT ON COLUMN em_cp_user_external_contact.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user_external_contact.open_user_id IS '用户在企业号内的唯一标识'
;
COMMENT ON COLUMN em_cp_user_external_contact.external_user_id IS '外部联系人的userid'
;
COMMENT ON COLUMN em_cp_user_external_contact.status IS '状态'
;
COMMENT ON COLUMN em_cp_user_external_contact.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_user_external_contact.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_external_contact.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_user_external_contact.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_external_contact.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_user_external_c_ui_idx ON em_cp_user_external_contact(open_user_id)
;
CREATE INDEX em_cp_user_external_c_eci_idx ON em_cp_user_external_contact(external_user_id)
;
CREATE INDEX em_cp_user_external_c_ti_idx ON em_cp_user_external_contact(tenant_id)
;