alter table em_cp_msgaudit_file add corp_id varchar(32)
;
COMMENT ON COLUMN em_cp_msgaudit_file.corp_id IS '企业号基本信息ID'
;
CREATE TABLE em_cp_msgaudit_key (
  id varchar(32) NOT NULL PRIMARY KEY,
  version NUMBER(11,0) DEFAULT NULL,
  private_key CLOB,
  public_key CLOB,
  remark CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_key IS '消息存档密钥'
;
COMMENT ON COLUMN em_cp_msgaudit_key.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_key.version IS '版本号'
;
COMMENT ON COLUMN em_cp_msgaudit_key.private_key IS '私钥'
;
COMMENT ON COLUMN em_cp_msgaudit_key.public_key IS '公钥'
;
COMMENT ON COLUMN em_cp_msgaudit_key.remark IS '备注'
;
COMMENT ON COLUMN em_cp_msgaudit_key.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_key.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_key.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_key.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_key.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_key.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_key_ti_idx ON em_cp_msgaudit_key(tenant_id)
;