CREATE TABLE em_cp_user_sync_cond_wx (
    id varchar(32) NOT NULL PRIMARY KEY,
    cp_corp_id varchar(32) DEFAULT NULL,
    outsys_id varchar(32) DEFAULT NULL,
    cond_type number(4,0) DEFAULT NULL,
    auth_type number(4,0) DEFAULT NULL,
    auth_type_name varchar(200) DEFAULT NULL,
    auth_value varchar(32) DEFAULT NULL,
    auth_value_name varchar(200) DEFAULT NULL,
    auth_seclevel varchar(32) DEFAULT NULL,
    auth_seclevel_max varchar(32) DEFAULT NULL,
    showorder number(10,0) DEFAULT NULL,
    status number(4,0) DEFAULT NULL,
    create_user_id varchar(32) DEFAULT NULL,
    create_time TIMESTAMP DEFAULT NULL,
    update_user_id varchar(32) DEFAULT NULL,
    update_time TIMESTAMP DEFAULT NULL,
    tenant_id varchar(32) DEFAULT NULL,
    is_contains_child number(4,0) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_sync_cond_wx IS '从企业微信同步 关联部门范围表'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.cp_corp_id 	 IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.outsys_id 	 IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.cond_type 	 IS '条件类型：1-人员，2-部门，3-分部'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_type 	 IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_type_name 	 IS '规则类型显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_value 	 IS '规则类型值'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_value_name 	 IS '规则类型值显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_seclevel 	 IS '规则安全级别最小值'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_seclevel_max 	IS '规则安全级别最大值'
;
