CREATE TABLE em_cp_schedule(
    id varchar(32) PRIMARY KEY,
    organizer varchar(32) NOT NULL,
    start_time TIMESTAMP NOT NULL,
    end_time TIMESTAMP NOT NULL,
    summary varchar(128),
    description varchar(512),
    attendees CLOB NOT NULL,
    location varchar(128),
    cal_id varchar(64),
    schedule_id varchar(64) NOT NULL,
    corp_id varchar(64) NOT NULL,
    status tinyint DEFAULT 1 ,
    create_user_id varchar(32) DEFAULT NULL,
    create_time TIMESTAMP DEFAULT NULL,
    update_user_id varchar(32) DEFAULT NULL,
    update_time TIMESTAMP DEFAULT NULL,
    tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_schedule IS '企业微信日程表'
;
COMMENT ON COLUMN em_cp_schedule.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_schedule.organizer  IS '日程组织者'
;
COMMENT ON COLUMN em_cp_schedule.start_time  IS '日程发起时间'
;
COMMENT ON COLUMN em_cp_schedule.end_time  IS '日程结束时间'
;
COMMENT ON COLUMN em_cp_schedule.summary  IS '日程标题'
;
COMMENT ON COLUMN em_cp_schedule.summary  IS '日程标题'
;
COMMENT ON COLUMN em_cp_schedule.description  IS '日程描述'
;
COMMENT ON COLUMN em_cp_schedule.attendees  IS '日程参与者'
;
COMMENT ON COLUMN em_cp_schedule.location  IS '日程地点'
;
COMMENT ON COLUMN em_cp_schedule.cal_id  IS '日程所属企业微信日历id'
;
COMMENT ON COLUMN em_cp_schedule.schedule_id  IS '企业微信日程id'
;
COMMENT ON COLUMN em_cp_schedule.corp_id  IS '本地企业号id'
;
COMMENT ON COLUMN em_cp_schedule.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_schedule.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_schedule.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_schedule.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_schedule.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_schedule.tenant_id  IS '企业租户ID'
;
