ALTER TABLE em_ehcache_cluster_setting RENAME TO em_ehcache_cluster_setting_old
;
CREATE TABLE em_ehcache_cluster_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled tinyint DEFAULT NULL,
  multicastgroupaddress varchar(255) DEFAULT NULL,
  multicastgroupport int DEFAULT NULL,
  timetolive int DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_ehcache_cluster_setting IS '缓存集群设置表'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.id IS '主键'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.enabled IS '是否启用集群'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.multicastgroupaddress IS '缓存集群使用的组播IP'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.multicastgroupport IS '缓存集群使用的端口'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.timetolive IS '缓存组播范围'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.update_time IS '最后修改时间'
;
INSERT INTO em_ehcache_cluster_setting(id,enabled,multicastgroupaddress,multicastgroupport,timetolive,create_user_id,create_time,update_user_id,update_time) SELECT id,enabled,multicastGroupAddress,multicastGroupPort,timeToLive,create_user_id,create_time,update_user_id,update_time FROM em_ehcache_cluster_setting_old
;