CREATE TABLE em_cp_user_opt_log (
  id varchar(32) PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  opt_level varchar(20) DEFAULT NULL,
  opt_source NUMBER(3,0) DEFAULT NULL,
  opt_type varchar(50) DEFAULT NULL,
  ip varchar(50) DEFAULT NULL,
  brief_info varchar(100) DEFAULT NULL,
  detail_info CLOB,
  req_body CLOB,
  resp_body CLOB,
  original_data CLOB,
  showorder NUMBER(24,0),
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_opt_log IS '云桥通讯录操作日志表'
;
COMMENT ON COLUMN em_cp_user_opt_log.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_user_opt_log.cp_corp_id  IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user_opt_log.opt_level  IS '操作级别'
;
COMMENT ON COLUMN em_cp_user_opt_log.opt_source  IS '操作来源：1-从APP同步，2-从EC同步，3-手动创建'
;
COMMENT ON COLUMN em_cp_user_opt_log.opt_type  IS '操作类型'
;
COMMENT ON COLUMN em_cp_user_opt_log.ip  IS '操作ip'
;
COMMENT ON COLUMN em_cp_user_opt_log.brief_info  IS '简要信息'
;
COMMENT ON COLUMN em_cp_user_opt_log.detail_info  IS '详细信息'
;
COMMENT ON COLUMN em_cp_user_opt_log.req_body  IS '请求信息'
;
COMMENT ON COLUMN em_cp_user_opt_log.resp_body  IS '响应信息'
;
COMMENT ON COLUMN em_cp_user_opt_log.original_data  IS '原始数据'
;
COMMENT ON COLUMN em_cp_user_opt_log.showorder  IS '显示顺序'
;
COMMENT ON COLUMN em_cp_user_opt_log.status  IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_user_opt_log.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_user_opt_log.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_opt_log.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_user_opt_log.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_opt_log.tenant_id  IS '企业租户ID'
;

create index idx_optlog_tenant_id on em_cp_user_opt_log(tenant_id)
;
create index idx_optlog_ti_cci on em_cp_user_opt_log(tenant_id,cp_corp_id)
;
create index idx_optlog_ti_cci_clb on em_cp_user_opt_log(tenant_id,cp_corp_id,create_time,opt_level,brief_info)
;
create index idx_optlog_ti_cci_csb on em_cp_user_opt_log(tenant_id,cp_corp_id,create_time,opt_source,brief_info)
;
create index idx_optlog_ti_cci_ctb on em_cp_user_opt_log(tenant_id,cp_corp_id,create_time,opt_type,brief_info)
;