CREATE TABLE `em_hrm_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_user_id` varchar(100) DEFAULT NULL COMMENT '用户在企业内的唯一标识',
  `user_name` varchar(100) DEFAULT NULL COMMENT '姓名',
  `nick_name` varchar(100) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '昵称',
  `english_name` varchar(100) DEFAULT NULL COMMENT '英文名',
  `mobile` varchar(50) DEFAULT NULL COMMENT '手机-企业内唯一',
  `position` varchar(100) DEFAULT NULL COMMENT '岗位',
  `gender` tinyint(4) DEFAULT NULL COMMENT '性别 1表示男性，2表示女性，0表示未知',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `telephone` varchar(100) DEFAULT NULL COMMENT '座机',
  `avatar` varchar(255) DEFAULT NULL COMMENT '头像',
  `showorder` decimal(10,2) DEFAULT NULL COMMENT '显示顺序',
  `isadmin` tinyint(4) DEFAULT NULL COMMENT '是否为管理员 1-是，0-否',
  `admin_password` varchar(100) DEFAULT NULL COMMENT '管理密码',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1=已激活，2=已禁用，3=已删除，4=未激活，5=已离职，6=已退出',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_user_id` (`open_user_id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录成员表'
;