CREATE TABLE `em_hrm_dept` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_dept_id` int(11) DEFAULT NULL COMMENT 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长',
  `dept_name` varchar(100) DEFAULT NULL comment '部门名称',
  `english_name` varchar(100) DEFAULT NULL comment '英文名称',
  `parent_id` varchar(32) DEFAULT NULL comment '上级部门ID',
  `all_parent_ids` varchar(1000) DEFAULT NULL comment '所有上级部门ID用逗号分隔',
  `showorder` decimal(10,2) DEFAULT NULL comment '显示顺序',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1-正常，2-封存，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_dept_id` (`open_dept_id`),
  KEY `parent_id` (`parent_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通信录部门表'
;