CREATE TABLE `em_hrm_tag_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `hrm_tag_id` varchar(32) DEFAULT NULL COMMENT '通讯录标签表ID',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_tag_id` (`hrm_tag_id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录标签与成员及部门关联表'
;