CREATE TABLE `em_setting_role` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_role_id` int(11) DEFAULT NULL COMMENT 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长',
  `role_name` varchar(100) DEFAULT NULL COMMENT '角色名称',
  `english_name` varchar(100) DEFAULT NULL comment '英文名称',
  `description` varchar(200) DEFAULT NULL comment '角色描述',
  `role_type` tinyint(4) DEFAULT NULL comment '角色类型 1-用户角色，2-应用角色，3-接口角色',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_role_id` (`open_role_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业管理角色表'
;
CREATE TABLE `em_setting_role_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `setting_role_id` varchar(32) DEFAULT NULL COMMENT '角色ID',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `setting_role_id` (`setting_role_id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业管理角色与基础用户关联表'
;
CREATE TABLE `em_setting_role_right` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `setting_role_id` varchar(32) DEFAULT NULL COMMENT '管理组ID',
  `right_data_type` tinyint(4) DEFAULT NULL COMMENT '管理数据类型 1-通讯录部门，2-通讯录成员，3-应用',
  `right_data_id` varchar(32) DEFAULT NULL comment '管理的数据ID，即部门成员应用ID',
  `right_level` tinyint(4) DEFAULT NULL comment '管理的权限级别，对应通讯录：1-仅具有查看权限，2-具有管理权限；对于应用：1-仅具有发送消息权限，2-具体管理权限',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `setting_role_id` (`setting_role_id`),
  KEY `right_data_id` (`right_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业管理角色与权限关联表'
;