CREATE TABLE `em_sys_tenant_admin` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  `admin_type` tinyint(4) DEFAULT NULL COMMENT '管理员类型：1-创建人，2-超级管理员，3-分级管理员，4-外部管理员，5-应用管理员，6-接口管理员',
  `agent_base_id` varchar(32) DEFAULT NULL COMMENT '应用管理对应的应用ID',
  `admin_password` varchar(100) DEFAULT NULL COMMENT '管理密码',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `agent_base_id` (`agent_base_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='基础用户租户管理关联表'
;