CREATE TABLE `em_agent_base` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_agent_id` int(11) DEFAULT NULL COMMENT 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长',
  `agent_type` tinyint(4) DEFAULT NULL COMMENT '应用类型 1-链接型，2-打开第三方APP，3-ecology应用',
  `agent_name` varchar(100) DEFAULT NULL COMMENT '应用名称',
  `english_name` varchar(100) DEFAULT NULL comment '英文名称',
  `description` varchar(200) DEFAULT NULL comment '描述',
  `logo` varchar(255) DEFAULT NULL COMMENT '图标',
  `redirect_domain` varchar(100) DEFAULT NULL comment '可信域名',
  `home_url` varchar(200) DEFAULT NULL comment '应用主页地址',
  `home_url_pc` varchar(200) DEFAULT NULL comment 'PC版应用主页地址',
  `manage_url` varchar(200) DEFAULT NULL comment '后台管理主页',
  `report_location_flag` tinyint(4) DEFAULT NULL comment '企业应用是否打开地理位置上报 0：不上报；1：进入会话上报',
  `isreportenter` tinyint(4) DEFAULT NULL comment '是否上报用户进入应用事件。0：不接收；1：接收',
  `ios_pkgname` varchar(50) DEFAULT NULL comment '第三方APPiOS应用scheme',
  `ios_downloadurl` varchar(500) DEFAULT NULL comment '第三方APPiOS应用下载地址',
  `and_pkgname` varchar(50) DEFAULT NULL comment '第三方APPAndroid应用包名',
  `and_downloadurl` varchar(500) DEFAULT NULL comment '第三方APPAndroid应用下载地址',
  `app_auth` varchar(100) DEFAULT NULL comment '第三方APP访问验证参数',
  `app_gopage` varchar(500) DEFAULT NULL comment '第三方APP访问直接打开的地址',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_agent_id` (`open_agent_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业应用基本信息表'
;