CREATE TABLE `em_hrm_user_attr` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `attr_name` varchar(100) DEFAULT NULL COMMENT '自定义字段名称',
  `english_name` varchar(100) DEFAULT NULL COMMENT '自定义字段英文名称',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1=正常，3=已删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录成员自定义字段定义表'
;
CREATE TABLE `em_hrm_user_attr_value` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `hrm_user_id` varchar(32) DEFAULT NULL COMMENT '企业通讯录成员ID',
  `attr_id` varchar(32) DEFAULT NULL COMMENT '自定义字段定义表ID',
  `attr_value` varchar(100) DEFAULT NULL COMMENT '自定义字段值',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1=正常，3=已删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录成员自定义字段内容表'
;