DROP TABLE IF EXISTS `em_log_access`
;
CREATE TABLE `em_log_access` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` varchar(255) DEFAULT NULL COMMENT '用户名',
  `operation` varchar(255) DEFAULT NULL COMMENT '操作',
  `client` varchar(255) DEFAULT NULL COMMENT '客户端类型：IOS、安卓、PC、WEB',
  `device_id` varchar(255) DEFAULT NULL COMMENT '客户端硬件标识',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `create_time` datetime DEFAULT NULL COMMENT '日志创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `create_time` (`create_time`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='访问日志'
;