DROP TABLE IF EXISTS `em_log_error`
;
CREATE TABLE `em_log_error` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` varchar(255) DEFAULT NULL COMMENT '用户名',
  `operation` varchar(255) DEFAULT NULL COMMENT '操作',
  `params` text COMMENT '请求参数',
  `error_type` varchar(255) DEFAULT NULL COMMENT '错误类型',
  `exception` text COMMENT '异常信息',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `create_time` datetime DEFAULT NULL COMMENT '日志创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `create_time` (`create_time`),
   KEY `tenant_id` (`tenant_id`)
) COMMENT='错误日志'
;