DROP TABLE IF EXISTS `em_log_operation`
;
CREATE TABLE `em_log_operation` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` varchar(255) DEFAULT NULL COMMENT '用户名',
  `hrm_user_id` varchar(32) DEFAULT NULL COMMENT '通讯录用户ID',
  `hrm_user_name` varchar(255) DEFAULT NULL COMMENT '通讯录用户名',
  `operation` varchar(255) DEFAULT NULL COMMENT '操作',
  `method` varchar(255) DEFAULT NULL COMMENT '请求方法',
  `params` text COMMENT '请求参数',
  `data_name` varchar(255) DEFAULT NULL COMMENT '操作的数据名称',
  `cost_time` int(11) DEFAULT NULL COMMENT '操作时长',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `create_time` datetime DEFAULT NULL COMMENT '日志创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `tenant_id` (`tenant_id`),
  KEY `create_time` (`create_time`),
  KEY `hrm_user_id` (`hrm_user_id`)
) COMMENT='操作日志'
;