DROP TABLE IF EXISTS `em_agent_msg_log`
;
CREATE TABLE `em_agent_msg_log` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_agent_id` int(11) DEFAULT NULL COMMENT '企业应用openid',
  `touser` text DEFAULT NULL COMMENT '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送',
  `toparty` text DEFAULT NULL COMMENT '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数',
  `totag` text DEFAULT NULL comment '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数',
  `msgtype` varchar(10) DEFAULT NULL comment '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文',
  `safe` tinyint(4) DEFAULT 0 COMMENT '表示是否是保密消息，0表示否，1表示是，默认0',
  `datainfo` text DEFAULT NULL comment '发送数据的详细信息，json格式的完整内容',
  `errcode` int(11) DEFAULT NULL COMMENT '发送结果状态码',
  `errmsg` varchar(1000) DEFAULT NULL COMMENT '错误信息',
  `invaliduser` text DEFAULT NULL COMMENT '无效的成员ID列表',
  `invalidparty` text DEFAULT NULL COMMENT '无效的部门ID列表',
  `invalidtag` text DEFAULT NULL comment '无效的标签ID列表',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_agent_id` (`open_agent_id`),
  KEY `create_time` (`create_time`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业应用发送消息记录表'
;