CREATE TABLE `em_setting_clientset_show` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型 1-移动APP，2-PC客户端，3-web客户端',
  `set_type` tinyint(4) DEFAULT NULL COMMENT '设置项类型 1-登录前显示，2-登录后显示',
  `set_tag` tinyint(4) DEFAULT NULL COMMENT '设置项标识 1-欢迎页背景图片，2-欢迎词内容，3-欢迎词字体颜色，4-登录页logo，5-登录页背景色，6-登录页底部信息内容，7-登录页底部信息字体颜色，21-顶部背景色，22-顶部文字颜色，23-顶部功能菜单背景色，24-顶部功能菜单文字颜色，25-导航栏背景色，26-导航栏文字未选中颜色，27-导航栏文字已选中颜色',
  `set_value` varchar(500) DEFAULT NULL COMMENT '设置内容',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端显示设置表'
;
CREATE TABLE `em_setting_clientset_func` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型 1-移动APP，2-PC客户端，3-web客户端',
  `set_type` tinyint(4) DEFAULT NULL COMMENT '设置项类型 1-顶部右上角功能，2-导航栏功能',
  `icon_unselected` varchar(32) DEFAULT NULL COMMENT '未选中图标',
  `icon_selected` varchar(32) DEFAULT NULL COMMENT '已选中图标',
  `show_name` varchar(20) DEFAULT NULL COMMENT '显示名称',
  `show_order` decimal(10,2) DEFAULT NULL COMMENT '显示顺序',
  `func_type` int(11) DEFAULT NULL COMMENT '功能类型',
  `func_value` varchar(200) DEFAULT NULL COMMENT '功能扩展值',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端功能设置表'
;