CREATE TABLE `em_msg_group` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `group_type` tinyint(4) DEFAULT 1 COMMENT '群组类型 1-普通群，2-部门群，3-公司群',
  `group_name` varchar(100) DEFAULT NULL COMMENT '群组名称',
  `english_name` varchar(100) DEFAULT NULL comment '英文名称',
  `description` varchar(200) DEFAULT NULL comment '描述',
  `logo` varchar(255) DEFAULT NULL COMMENT '头像',
  `server_group_id` varchar(50) DEFAULT NULL COMMENT '对应的消息服务器群组ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业消息群组基础表'
;
CREATE TABLE `em_msg_group_member` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `group_id` varchar(32) DEFAULT NULL COMMENT '所属群组ID',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '成员基础用户ID',
  `member_type` tinyint(4) DEFAULT 3 COMMENT '成员类型 1-群主，2-管理员，3-普通成员',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业消息群组成员表'
;
CREATE TABLE `em_msg_group_notice` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `group_id` varchar(32) DEFAULT NULL COMMENT '所属群组ID',
  `remark` text DEFAULT NULL COMMENT '公告内容',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业消息群组公告表'
;