CREATE TABLE `em_setting_hrm_right_base` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `right_base_name` varchar(100) DEFAULT NULL COMMENT '权限规则名称',
  `priority` int(11) DEFAULT 0 COMMENT '优先级',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录权限规则基础表'
;

CREATE TABLE `em_setting_hrm_right_target` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `right_base_id` varchar(32) DEFAULT NULL COMMENT '权限设置基础ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `right_base_id` (`right_base_id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录权限规则对象表'
;

CREATE TABLE `em_setting_hrm_right_data` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `right_base_id` varchar(32) DEFAULT NULL COMMENT '权限设置基础ID',
  `right_type` int(11) DEFAULT 1 COMMENT '权限类型：1-查看，2-发消息，3-打电话，9-查看具体字段',
  `right_field_id` varchar(32) DEFAULT NULL COMMENT '查看具体字段的ID，当值为1时表示手机号，否则为em_hrm_user_attr表的ID值',
  `permit_type` tinyint(4) DEFAULT 1 COMMENT '允许或禁止：1-允许，2-禁止',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级），5-本部门（含下级），6-本部门（不含下级）',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `right_base_id` (`right_base_id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录权限规则数据表'
;