DROP TABLE IF EXISTS `em_sys_industry_category`
;
CREATE TABLE `em_sys_industry_category` (
  `category_code` varchar(4) NOT NULL COMMENT '行业代码',
  `category_name` varchar(100) NOT NULL COMMENT '行业类别名称',
  `descrition` varchar(1000) DEFAULT NULL COMMENT '行业描述',
  PRIMARY KEY (`category_code`)
) COMMENT='行业门类表'
;
INSERT INTO `em_sys_industry_category` VALUES ('A', '农、林、牧、渔业', '本门类包括01～05大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('B', '采矿业', '本类包括06～12大类，采矿业指对固体（如煤和矿物）、液体（如原油）或气体（如天然气）等自然产生的矿物的采掘；包括地下或地上采掘、矿井的运行，以及一般在矿址或矿址附近从事的旨在加工原材料的所有辅助性工作，例如碾磨、选矿和处理，均属本类活动；还包括使原料得以销售所需的准备工作；不包括水的蓄集、净化和分配，以及地质勘查、建筑工程活动')
;
INSERT INTO `em_sys_industry_category` VALUES ('C', '制造业', '本门类包括13～43大类，指经物理变化或化学变化后成为新的产品，不论是动力机械制造，还是手工制作；也不论产品是批发销售，还是零售，均视为制造。建筑物中的各种制成品、零部件的生产应视为制造，但在建筑预制品工地，把主要部件组装成桥梁、仓库设备、铁路与高架公路、升降机与电梯、管道设备、喷水设备、暖气设备、通风设备与空调设备，照明与安装电线等组装活动，以及建筑物的装置，均列为建筑活动。本门类包括机电产品的再制造，指将废旧汽车零部件、工程机械、机床等进行专业化修复的批量化生产过程，再制造的产品达到与原有新产品相同的质量和性能')
;
INSERT INTO `em_sys_industry_category` VALUES ('D', '电力、热力、燃气及水生产和供应业', '本门类包括44～46大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('E', '建筑业', '本门类包括47～50大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('F', '批发和零售业', '本门类包括51和52大类，指商品在流通环节中的批发活动和零售活动')
;
INSERT INTO `em_sys_industry_category` VALUES ('G', '交通运输、仓储和邮政业', '本门类包括53～60大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('H', '住宿和餐饮业', '本门类包括61和62大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('I', '信息传输、软件和信息技术服务业', '本门类包括63～65大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('J', '金融业', '本门类包括66～69大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('K', '房地产业', '本门类包括70大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('L', '租赁和商务服务业', '本门类包括71和72大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('M', '科学研究和技术服务业', '本门类包括73～75大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('N', '水利、环境和公共设施管理业', '本门类包括76～78大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('O', '居民服务、修理和其他服务业', '本门类包括79～81大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('P', '教育', '本门类包括82大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('Q', '卫生和社会工作', '本门类包括83和84大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('R', '文化、体育和娱乐业', '本门类包括85～89大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('S', '公共管理、社会保障和社会组织', '本类包括90～95大类')
;
INSERT INTO `em_sys_industry_category` VALUES ('T', '国际组织', '本门类包括96大类')
;