DROP TABLE IF EXISTS `em_log_access`
;
CREATE TABLE `em_log_access` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` varchar(255) DEFAULT NULL COMMENT '用户名',
  `base_user_status` tinyint(4) DEFAULT NULL COMMENT '用户状态 1-已注册，2-未注册，3-删除',
  `operation` varchar(255) DEFAULT NULL COMMENT '操作：login-登录，logout-登出',
  `access_token` varchar(100) DEFAULT NULL COMMENT '访问token',
  `login_type` tinyint(4) DEFAULT NULL COMMENT '登录类型：1-客户端，2-管理端，3-接口',
  `login_mode` tinyint(4) DEFAULT NULL COMMENT '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版',
  `client_version` varchar(50) DEFAULT NULL COMMENT '客户端版本',
  `device_id` varchar(255) DEFAULT NULL COMMENT '客户端硬件标识',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `user_agent` varchar(500) DEFAULT NULL COMMENT '访问头信息',
  `create_time` datetime DEFAULT NULL COMMENT '日志创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `create_time` (`create_time`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='访问日志'
;