CREATE TABLE `em_setting_clientset_theme_base` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型 1-移动APP，2-PC客户端，3-web客户端',
  `theme_name` varchar(100) DEFAULT NULL COMMENT '主题名称',
  `nav_bgcolor` varchar(50) DEFAULT NULL COMMENT '移动端底部导航背景颜色',
  `nav_textcolor_default` varchar(50) DEFAULT NULL COMMENT '移动端底部导航文字默认颜色',
  `nav_textcolor_selected` varchar(50) DEFAULT NULL COMMENT '移动端底部导航文字选中颜色',
  `nav_showtext` tinyint(4) DEFAULT 1 COMMENT '移动端底部导航是否显示文字 1-显示，0-不显示',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端主题基础信息表'
;
CREATE TABLE `em_setting_clientset_theme_view` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `theme_base_id` varchar(32) DEFAULT NULL COMMENT '主题ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `theme_base_id` (`theme_base_id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端主题可见范围设置表'
;

CREATE TABLE `em_setting_clientset_theme_nav` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `theme_base_id` varchar(32) DEFAULT NULL COMMENT '主题ID',
  `nav_name` varchar(50) DEFAULT NULL COMMENT '导航名称',
  `nav_func` int(11) DEFAULT NULL COMMENT '导航功能：-1-消息，-2-通讯录，-3-工作台，-4-我，1-应用，2-门户，3-自定义链接',
  `nav_func_set1` varchar(200) DEFAULT NULL COMMENT '导航功能设置，如应用ID、门户ID，自定义链接地址等',
  `nav_func_set2` varchar(200) DEFAULT NULL COMMENT '导航功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口',
  `isshow` tinyint(4) DEFAULT NULL COMMENT '是否显示：1-登显示，0-不显示',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `isdefault` tinyint(4) DEFAULT NULL COMMENT '是否默认：1-默认，0-不默认',
  `icon_default` varchar(200) NOT NULL COMMENT '默认显示图标',
  `icon_selected` varchar(200) NOT NULL COMMENT '选中显示图标',
  `top_bgcolor` varchar(50) DEFAULT NULL COMMENT '顶部背景颜色',
  `top_title` varchar(50) DEFAULT NULL COMMENT '顶部显示标题',
  `icon_more` varchar(200) NOT NULL COMMENT '顶部更多按钮图标',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `theme_base_id` (`theme_base_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端主题导航明细设置表'
;

CREATE TABLE `em_setting_clientset_theme_nav_btn` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `theme_base_id` varchar(32) DEFAULT NULL COMMENT '主题ID',
  `theme_nav_id` varchar(32) DEFAULT NULL COMMENT '导航明细ID',
  `btn_type` tinyint(4) DEFAULT NULL COMMENT '按钮类型 1-右上角按钮，2-消息功能按钮',
  `btn_name` varchar(50) DEFAULT NULL COMMENT '按钮名称',
  `btn_func` int(11) DEFAULT NULL COMMENT '按钮功能：1-应用，2-门户，3-自定义链接',
  `btn_func_set1` varchar(200) DEFAULT NULL COMMENT '按钮功能设置，如应用ID、门户ID，自定义链接地址等',
  `btn_func_set2` varchar(200) DEFAULT NULL COMMENT '按钮功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口',
  `isshow` tinyint(4) DEFAULT NULL COMMENT '是否显示：1-登显示，0-不显示',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `icon_default` varchar(200) NOT NULL COMMENT '默认显示图标',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `theme_base_id` (`theme_base_id`),
  KEY `theme_nav_id` (`theme_nav_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端主题导航按钮设置表'
;