CREATE TABLE `em_setting_clientset_portal_base` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型 1-移动APP，2-PC客户端，3-web客户端',
  `portal_name` varchar(100) DEFAULT NULL COMMENT '门户名称',
  `show_type` tinyint(4) DEFAULT 1 COMMENT '显示模式',
  `isdefault` tinyint(4) DEFAULT NULL COMMENT '是否默认门户：1-是、0-否',
  `isuserset` tinyint(4) DEFAULT NULL COMMENT '是否支持用户自定义：1-是、0-否',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端门户基础信息表'
;

CREATE TABLE `em_setting_clientset_portal_category` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `portal_base_id` varchar(32) DEFAULT NULL COMMENT '主题ID',
  `category_type` tinyint(4) DEFAULT NULL COMMENT '分组类型：1-普通分组，2-其他应用，3-常用功能分组',
  `category_name` varchar(50) DEFAULT NULL COMMENT '分组名称',
  `english_name` varchar(50) DEFAULT NULL COMMENT '分组英文名称',
  `isshowtitle` tinyint(4) DEFAULT NULL COMMENT '是否显示分组标题：1-显示，0-不显示',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `icon_default` varchar(200) DEFAULT NULL COMMENT '默认显示图标',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `portal_base_id` (`portal_base_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端门户分组信息表'
;

CREATE TABLE `em_setting_clientset_portal_category_element` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `portal_base_id` varchar(32) DEFAULT NULL COMMENT '门户ID',
  `portal_category_id` varchar(32) DEFAULT NULL COMMENT '分组ID',
  `btn_type` tinyint(4) DEFAULT NULL COMMENT '按钮类型 1-右上角按钮，2-消息功能按钮',
  `element_name` varchar(50) DEFAULT NULL COMMENT '元素名称',
  `english_name` varchar(50) DEFAULT NULL COMMENT '英文名称',
  `element_type` int(11) DEFAULT NULL COMMENT '元素类型：1-应用，2-门户，3-自定义链接，4-幻灯片',
  `element_set1` varchar(200) DEFAULT NULL COMMENT '元素功能设置，如应用ID、门户ID、自定义链接地址，幻灯片图片等',
  `element_set2` varchar(200) DEFAULT NULL COMMENT '元素功能设置，如链接的打开方式1表示默认窗口，2表示新窗口',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `icon_default` varchar(200) DEFAULT NULL COMMENT '默认显示图标',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `portal_base_id` (`portal_base_id`),
  KEY `portal_category_id` (`portal_category_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端门户分组元素设置表'
;

CREATE TABLE `em_setting_clientset_portal_category_userset` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  `portal_base_id` varchar(32) DEFAULT NULL COMMENT '门户ID',
  `portal_category_id` varchar(32) DEFAULT NULL COMMENT '分组ID，其中-1表示隐藏的元素分组',
  `element_ids` varchar(500) DEFAULT NULL COMMENT '此分组设置的元素id集合用逗号分隔',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `portal_base_id` (`portal_base_id`),
  KEY `portal_category_id` (`portal_category_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业客户端门户分组用户自定义设置表'
;