DROP TABLE IF EXISTS `em_log_manage`
;
CREATE TABLE `em_log_manage`  (
  `id` VARCHAR(32) NOT NULL COMMENT '主键ID',
  `base_user_id` VARCHAR(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` VARCHAR(100)  DEFAULT NULL COMMENT '用户名',
  `hrm_user_id` VARCHAR(32)  DEFAULT NULL COMMENT '通讯录用户ID',
  `hrm_user_name` VARCHAR(100) DEFAULT NULL COMMENT '通讯录用户名',
  `type1` INT(11)  DEFAULT NULL COMMENT '操作功能模块',
  `type2` INT(11)  DEFAULT NULL COMMENT '操作具体功能',
  `type3` INT(11)  DEFAULT NULL COMMENT '操作具体类型',
  `datainfo` TEXT  COMMENT '相关数据',
  `method` VARCHAR(255)  DEFAULT NULL COMMENT '请求方法',
  `params` TEXT  COMMENT '请求参数',
  `ip` VARCHAR(255)  DEFAULT NULL COMMENT 'IP地址',
  `showorder` INT(11)  DEFAULT NULL AUTO_INCREMENT,
  `create_time` DATETIME DEFAULT NULL COMMENT '创建时间',
  `tenant_id` VARCHAR(32)  DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id`(`base_user_id`),
  KEY `tenant_id`(`tenant_id`),
  KEY `hrm_user_id`(`hrm_user_id`),
  KEY `create_time`(`create_time`),
  KEY `showorder_index`(`showorder`)
) COMMENT = '管理端操作日志' 
;