CREATE TABLE `em_hrm_user_sync_set` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `sys_task_id` varchar(32) DEFAULT NULL COMMENT '定时同步任务ID',
  `root_dept_id` varchar(32) DEFAULT NULL COMMENT '顶级部门ID，对应em_hrm_dept表主键ID',
  `baseid_type` tinyint(4) DEFAULT 1 COMMENT '新成员生成基础用户信息时ID的规则：1-使用系统默认的uuid ，2-使用ecology系统的数据库ID',
  `userid_field` tinyint(4) DEFAULT 1 COMMENT '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号',
  `match_user_field` tinyint(4) DEFAULT 1 COMMENT '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱',
  `match_outsys_field` tinyint(4) DEFAULT 1 COMMENT '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱',
  `user_del_type` tinyint(4) DEFAULT 1 COMMENT '离职成员的处理方式：1-禁用 ，2-删除',
  `dept_sync_type` tinyint(4) DEFAULT 1 COMMENT '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变',
  `isalluser` tinyint(4) DEFAULT 0 COMMENT '是否同步无账号人员：0-否 ，1-是',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `outsys_id` (`outsys_id`)
) COMMENT='通讯录成员与集成系统人员同步设置表'
;