DROP TABLE IF EXISTS `em_ehcache_cacheinfo`
;
CREATE TABLE `em_ehcache_cacheinfo`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cacheName` varchar(191) DEFAULT NULL COMMENT '缓存名称',
  `maxEntriesLocalHeap` bigint(20) DEFAULT NULL COMMENT '同maxElementsInMemory，内存中缓存的element的最大数目',
  `maxEntriesLocalDisk` bigint(20) NULL DEFAULT NULL COMMENT '同maxElementsOnDisk，磁盘上缓存的element的最大数目',
  `eternal` tinyint(1) DEFAULT NULL COMMENT '缓存中的element是否永久有效',
  `clearOnFlush` tinyint(1) DEFAULT NULL COMMENT '缓存满了是否删除',
  `timeToIdleSeconds` bigint(20) DEFAULT NULL COMMENT '缓存过期前的空闲时间',
  `timeToLiveSeconds` bigint(20) DEFAULT NULL COMMENT '缓存过期前的生存时间',
  `diskSpoolBufferSizeMB` int(11) DEFAULT NULL COMMENT '磁盘缓存的缓存区大小',
  `persistenceStrategy` enum('LOCALTEMPSWAP','LOCALRESTARTABLE','NONE','DISTRIBUTED') DEFAULT NULL COMMENT '缓存持久化策略',
  `diskExpiryThreadIntervalSeconds` bigint(20) DEFAULT NULL COMMENT '磁盘缓存的清理线程运行间隔',
  `memoryStoreEvictionPolicy` enum('LRU','LFU','FIFO') DEFAULT NULL COMMENT '移除缓存中element的策略',
  `transactionalMode` enum('OFF','LOCAL','XA','XA_STRICT') DEFAULT NULL COMMENT '缓存事务模式',
  `isDefaultCache` tinyint(1) DEFAULT NULL COMMENT '是否为默认缓存',
  `allow_remove` tinyint(1) DEFAULT NULL COMMENT '是否允许手动清空缓存：0-不允许、1-允许',
  PRIMARY KEY (`id`),
  UNIQUE INDEX `cacheName`(`cacheName`)
) AUTO_INCREMENT=15 COMMENT = '缓存信息表'
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (1, NULL, 1000, 100000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'LRU', 'OFF', 1, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (2, 'emobile:sys', 10, 0, 0, 1, 1800, 1800, 1024, NULL, 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (3, 'emobile:common:hrmConvert', 10000, 10000000, 0, 1, 7200, 7200, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (4, 'emobile:common:agentConvert', 10000, 10000000, 0, 1, 7200, 7200, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (5, 'emobile:common:tenantConvert', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (6, 'emobile:common:mobileArea', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (7, 'emobile:common:province', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (8, 'emobile:common:city', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (9, 'emobile:common:tradecate', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (10, 'emobile:common:tradetype', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (11, 'emobile:common:task', 5000, 0, 0, 1, 1800, 1800, 1024, NULL, 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (12, 'emobile:common:hrmRightData', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (13, 'emobile:common:sysDefaultTheme', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;
INSERT INTO `em_ehcache_cacheinfo` VALUES (14, 'emobile:common:duplicateToken', 10000, 10000000, 0, 1, 1800, 1800, 1024, 'LOCALTEMPSWAP', 120, 'FIFO', 'OFF', 0, 1)
;