DROP TABLE IF EXISTS `em_ehcache_cluster_node`
;
CREATE TABLE `em_ehcache_cluster_node`  (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `node_id` varchar(191) DEFAULT NULL COMMENT '节点id',
  `node_name` varchar(255) DEFAULT NULL COMMENT '节点名称',
  `computer_name` varchar(255) DEFAULT NULL COMMENT '计算机名称',
  `local_ips` varchar(255) DEFAULT NULL COMMENT '本机所有ip地址',
  `ip_for_cluster` varchar(255) DEFAULT NULL COMMENT '缓存集群使用的ip',
  `os_name` varchar(255) DEFAULT NULL COMMENT '操作系统',
  `last_start_time` datetime DEFAULT NULL COMMENT '最后启动时间',
  `port` int(11) DEFAULT NULL COMMENT '注册端口',
  `remote_object_port` int(11) DEFAULT NULL COMMENT '服务端口',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '最后修改人',
  `update_time` datetime DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`id`),
  UNIQUE INDEX `node_id`(`node_id`)
) COMMENT = '缓存集群节点表'
;