CREATE TABLE `em_video_chat_base` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `chat_name` varchar(100) DEFAULT NULL COMMENT '会话名称',
  `chat_uid` varchar(100) DEFAULT NULL COMMENT '会话标识，相同参与人的会话标识相同，即为同一个会话',
  `chat_type` tinyint(4) DEFAULT NULL COMMENT '会话类型：1-点对点，2-会议',
  `chat_member_count` int(11) DEFAULT NULL COMMENT '会话所有成员数',
  `chat_member_ids` text DEFAULT NULL COMMENT '会话所有成员ID逗号分隔',
  `last_call_sender_id` varchar(32) DEFAULT NULL COMMENT '最后一次的通话发起人ID，对应em_sys_base_user表的主键',
  `last_call_type` tinyint(4) DEFAULT NULL COMMENT '最后一次的通话类型 1-音频 2-视频 3-sip电话 4-普通电话',
  `last_call_time` bigint DEFAULT NULL COMMENT '最后一次的通话时间', 
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `chat_uid` (`chat_uid`)
) COMMENT='音视频会话基本信息表'
;
CREATE TABLE `em_video_chat_mine` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `chat_member_id` varchar(32) DEFAULT NULL COMMENT '会话成员ID，对应em_sys_base_user表的主键',
  `chat_base_id` varchar(32) DEFAULT NULL COMMENT '会话基本信息表ID',
  `chat_target_id` varchar(32) DEFAULT NULL COMMENT '点对点类型会话目标人员ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `chat_member_id` (`chat_member_id`),
  KEY `chat_base_id` (`chat_base_id`)
) COMMENT='音视频会话成员会话列表信息表'
;
CREATE TABLE `em_video_chat_call` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `chat_base_id` varchar(32) DEFAULT NULL COMMENT '会话基本信息表ID',
  `chat_type` tinyint(4) DEFAULT NULL COMMENT '会话类型：1-点对点，2-会议',
  `call_sender_id` varchar(32) DEFAULT NULL COMMENT '通话发起人ID，对应em_sys_base_user表的主键',
  `call_type` tinyint(4) DEFAULT NULL COMMENT '通话类型 1-音频 2-视频 3-sip电话 4-普通电话',
  `call_status` tinyint(4) DEFAULT NULL COMMENT '通话状态：1-进行中，2-结束',
  `call_time` bigint DEFAULT NULL COMMENT '通话时间',
  `call_duration` int(11) DEFAULT NULL COMMENT '通话时长，单位为秒',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `chat_base_id` (`chat_base_id`),
  KEY `call_sender_id` (`call_sender_id`)
) COMMENT='音视频会话通话记录表'
;

CREATE TABLE `em_video_chat_call_attend` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `chat_call_id` varchar(32) DEFAULT NULL COMMENT '会话通话记录表ID',
  `attend_member_id` varchar(32) DEFAULT NULL COMMENT '通话参与人ID，对应em_sys_base_user表的主键',
  `attend_type` tinyint(4) DEFAULT NULL COMMENT '参与类型 1-发起，2-加入，3-退出，4-踢出',
  `attend_target_ids` text DEFAULT NULL COMMENT '会话记录目标成员ID逗号分隔',
  `attend_time` bigint DEFAULT NULL COMMENT '参与时间',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `chat_call_id` (`chat_call_id`),
  KEY `attend_member_id` (`attend_member_id`)
) COMMENT='音视频会话通话记录参与明细表'
;