CREATE TABLE `em_hrm_group` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_group_id` int(11) DEFAULT NULL COMMENT 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长',
  `group_name` varchar(100) DEFAULT NULL COMMENT '分组名称',
  `english_name` varchar(100) DEFAULT NULL comment '英文名称',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1-正常，2-禁用，3-删除',
  `relate_role_id` varchar(32) DEFAULT NULL COMMENT '分组所属角色ID，关联em_setting_role表的主键，如果为0则表示超级管理员创建',
  `group_type` tinyint(4) DEFAULT NULL COMMENT '类型，1-通用分组，2-私人分组',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_group_id` (`open_group_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通信录分组表'
;

CREATE TABLE `em_hrm_group_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `hrm_group_id` varchar(32) DEFAULT NULL COMMENT '通讯录分组表ID',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_group_id` (`hrm_group_id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业通讯录分组与成员及部门关联表'
;

ALTER TABLE em_hrm_group add index relate_role_id  (relate_role_id) 
;