CREATE TABLE `em_setting_clientset_scan_rule`  (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `rule_name` varchar(50) COMMENT '规则名称',
  `client_type` tinyint(4) DEFAULT 0 COMMENT '适用客户端类型：1-全部，2-ios，3-android',
  `matching_mode` tinyint(4) COMMENT '匹配方式：1-包含，2-开头，3-结束，4-完全匹配，5-正则表达式，6-全部',
  `action_type` tinyint(4) COMMENT '执行动作类型：1-访问地址，2-浮出显示内容，3-新窗口显示内容，4-请求第三方服务，5-添加名片，6-打开某个应用，7-调用本地功能，8-不做任何操作，9-自定义',
  `action_setting1` varchar(500) COMMENT '执行动作参数1',
  `action_setting2` varchar(500) COMMENT '执行动作参数2',
  `action_setting3` varchar(500) COMMENT '执行动作参数3',
  `close_scan` tinyint(4) DEFAULT 1  COMMENT '是否关闭扫码器：1-是，0-否',
  `play_sound` tinyint(4) DEFAULT 1  COMMENT '是否播放提示音：1-是，0-否',
  `priority` int(11) DEFAULT 0 COMMENT '优先级，值越小优先级越高',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常，2-禁用，3-删除',
  `publish_time` datetime DEFAULT NULL COMMENT '发布时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT = '客户端扫码规则表'
;