CREATE TABLE `em_sys_watermark_setting` (
  `id` varchar(32) NOT NULL,
  `enable_msg_list` tinyint(4) DEFAULT NULL COMMENT '消息会话列表是否启用水印：0-禁用、1-启用',
  `enable_msg_window` tinyint(4) DEFAULT NULL COMMENT '消息会话窗口是否启用水印：0-禁用、1-启用',
  `enable_msg_prop` tinyint(4) DEFAULT NULL COMMENT '消息会话属性是否启用水印：0-禁用、1-启用',
  `enable_contact_home` tinyint(4) DEFAULT NULL COMMENT '通讯录主页是否启用水印：0-禁用、1-启用',
  `enable_contact_list` tinyint(4) DEFAULT NULL COMMENT '通讯录列表是否启用水印：0-禁用、1-启用',
  `enable_contact_view` tinyint(4) DEFAULT NULL COMMENT '通讯录详情是否启用水印：0-禁用、1-启用',
  `enable_webview_default` tinyint(4) DEFAULT NULL COMMENT '加载页面默认是否启用水印：0-禁用、1-启用',
  `spacing_val` int(11) DEFAULT NULL COMMENT '水印间距值，单位PX',
  `density_val` int(11) DEFAULT NULL COMMENT '水印密度值，分1、2、3三个等级，数值越大密度越大',
  `content_val1` varchar(100) DEFAULT NULL COMMENT '第一行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等',
  `font_size1` int(11) DEFAULT NULL COMMENT '第一行字体大小，单位PX',
  `content_val2` varchar(100) DEFAULT NULL COMMENT '第二行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等',
  `font_size2` int(11) DEFAULT NULL COMMENT '第二行字体大小，单位PX',
  `content_val3` varchar(100) DEFAULT NULL COMMENT '第三行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等',
  `font_size3` int(11) DEFAULT NULL COMMENT '第三行字体大小，单位PX',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常、3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='系统水印设置'
;
INSERT INTO `em_sys_watermark_setting` VALUES ('1', 0, 1, 0, 0, 0, 1, 0, 5, 2, '${username},${mobileL4}', 14, '${date}', 14, null, null, 1, '1', now(), null, null, '1')
;
