CREATE TABLE `em_sys_lang_base` (
  `id` varchar(32) NOT NULL,
  `lang_name` varchar(10) DEFAULT NULL COMMENT '语言名称',
  `lang_tag` varchar(10) DEFAULT NULL COMMENT '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语',
  `isdefault` tinyint(4) DEFAULT NULL COMMENT '是否默认：1-是、0-否',
  `show_order` decimal(10,2) DEFAULT NULL COMMENT '显示顺序',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常、2-禁用、3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='系统多语言设置'
;
INSERT INTO `em_sys_lang_base` VALUES ('1', '简体中文', 'zh', 1, 1, 1, '1', now(), null, null, '1')
;
INSERT INTO `em_sys_lang_base` VALUES ('2', '繁體中文', 'zh_TW', 0, 2, 1, '1', now(), null, null, '1')
;
INSERT INTO `em_sys_lang_base` VALUES ('3', 'English', 'en', 0, 3, 1, '1', now(), null, null, '1')
;

CREATE TABLE `em_sys_lang_clientset` (
  `id` varchar(32) NOT NULL,
  `client_type` tinyint(4) DEFAULT NULL COMMENT '客户端类型 1-移动APP，2-PC端',
  `lang_tag` varchar(10) DEFAULT NULL COMMENT '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语',
  `set_name` varchar(100) DEFAULT NULL COMMENT '设置项名称',
  `set_value` varchar(200) DEFAULT NULL COMMENT '设置项显示内容',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常、3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='客户端多语言设置'
;