CREATE TABLE `em_cp_corp` (
  `id` varchar(32) NOT NULL,
  `corp_name` varchar(50) DEFAULT NULL COMMENT '企业号名称',
  `open_corp_id` varchar(100) DEFAULT NULL COMMENT '企业号CORPID',
  `corp_secret` varchar(100) DEFAULT NULL COMMENT '企业号秘钥',
  `cp_type` tinyint(4) DEFAULT NULL COMMENT '企业号类型：1-企业微信、2-钉钉、3-简聊、4-蓝信、5-工作宝、8-金蝶云之家',
  `api_url_base` varchar(200) DEFAULT NULL COMMENT '企业号基础接口api地址',
  `api_url_user` varchar(200) DEFAULT NULL COMMENT '企业号获取用户信息接口api地址',
  `api_url_msg` varchar(200) DEFAULT NULL COMMENT '企业号消息推送接口api地址',
  `api_url_token` varchar(200) DEFAULT NULL COMMENT '企业号获取token接口api地址',
  `customer_name` varchar(200) DEFAULT NULL COMMENT '客户名称',
  `industry` varchar(200) DEFAULT NULL COMMENT '行业类型',
  `corp_desc` varchar(500) DEFAULT NULL COMMENT '企业号描述信息',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常、3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号基本信息表'
;

CREATE TABLE `em_cp_agent` (
  `id` varchar(32) NOT NULL,
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `agent_name` varchar(50) DEFAULT NULL COMMENT '应用名称',
  `open_agent_id` varchar(50) DEFAULT NULL COMMENT '应用ID',
  `agent_secret` varchar(100) DEFAULT NULL COMMENT '应用秘钥',
  `agent_desc` varchar(500) DEFAULT NULL COMMENT '应用描述信息',
  `callback_token` varchar(500) DEFAULT NULL COMMENT '回调令牌',
  `callback_aeskey` varchar(500) DEFAULT NULL COMMENT '回调秘钥',
  `redirect_domain` varchar(500) DEFAULT NULL COMMENT '可信域名',
  `report_location_flag` tinyint(4) DEFAULT 0 COMMENT '是否上报地理位置：1-是，0-否',
  `report_user` tinyint(4) DEFAULT 0 COMMENT '是否上报用户状态：1-是，0-否',
  `report_msg` tinyint(4) DEFAULT 0 COMMENT '是否上报用户消息：1-是，0-否',
  `auth_type` tinyint(4) DEFAULT 1 COMMENT '身份认证类型 1-auth2，2-SHA1，3-auth_code',
  `auth_secret` varchar(100) DEFAULT NULL COMMENT '身份认证秘钥，主要针对auth_type为2的情况',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常、3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号应用信息表'
;
DROP TABLE IF EXISTS `em_cp_dept`
;
CREATE TABLE `em_cp_dept` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `open_dept_id` varchar(100) DEFAULT NULL COMMENT '企业号中的部门ID',
  `dept_name` varchar(100) DEFAULT NULL comment '部门名称',
  `parent_id` varchar(100) DEFAULT NULL comment '上级部门ID',
  `all_parent_ids` varchar(1000) DEFAULT NULL comment '所有上级部门ID用逗号分隔',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '对应集成系统的ID',
  `outsys_dept_type` tinyint(4) DEFAULT NULL COMMENT '对应集成系统部门类型：1-分部，2-部门',
  `outsys_dept_id` varchar(32) DEFAULT NULL COMMENT '对应集成系统部门ID',
  `showorder` decimal(10,2) DEFAULT NULL comment '显示顺序',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_dept_id` (`open_dept_id`),
  KEY `parent_id` (`parent_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业号通讯录部门表'
;
DROP TABLE IF EXISTS `em_cp_user`
;
CREATE TABLE `em_cp_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `open_user_id` varchar(100) DEFAULT NULL COMMENT '用户在企业号内的唯一标识',
  `user_name` varchar(100) DEFAULT NULL COMMENT '姓名',
  `nick_name` varchar(100) DEFAULT NULL COMMENT '昵称',
  `english_name` varchar(100) DEFAULT NULL COMMENT '英文名',
  `mobile` varchar(50) DEFAULT NULL COMMENT '手机',
  `position` varchar(100) DEFAULT NULL COMMENT '岗位',
  `gender` tinyint(4) DEFAULT NULL COMMENT '性别 1表示男性，2表示女性，0表示未知',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `telephone` varchar(100) DEFAULT NULL COMMENT '座机',
  `avatar` varchar(500) DEFAULT NULL COMMENT '头像',
  `showorder` decimal(10,2) DEFAULT NULL COMMENT '显示顺序',
  `issync` tinyint(4) DEFAULT NULL COMMENT '是否已添加到企业号通讯录 1-是，0-否',
  `corp_status` tinyint(4) DEFAULT NULL COMMENT '企业号通讯录中的状态',
  `isadmin` tinyint(4) DEFAULT NULL COMMENT '是否为企业的管理员 1-是，0-否',
  `last_sync_status` tinyint(4) DEFAULT NULL COMMENT '最后同步到企业号中的状态：0-成功，1-失败',
  `last_sync_error` varchar(500) DEFAULT NULL COMMENT '最后同步到企业号中失败的信息',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_user_id` (`open_user_id`),
  KEY `base_user_id` (`base_user_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业号通讯录成员表'
;
DROP TABLE IF EXISTS `em_cp_dept_user`
;
CREATE TABLE `em_cp_dept_user` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_user_id` varchar(32) DEFAULT NULL COMMENT '通讯录人员表ID',
  `cp_dept_id` varchar(32) DEFAULT NULL COMMENT '通讯录部门表ID',
  `position` varchar(100) DEFAULT NULL COMMENT '岗位信息',
  `showorder` decimal(10,2) DEFAULT NULL COMMENT '显示顺序',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_user_id` (`cp_user_id`),
  KEY `cp_dept_id` (`cp_dept_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业号通讯录成员与部门关联表'
;
DROP TABLE IF EXISTS `em_cp_user_account`
;
CREATE TABLE `em_cp_user_account` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `outsys_user_id` varchar(32) DEFAULT NULL COMMENT '集成系统中的用户ID',
  `outsys_user_name` varchar(50) DEFAULT NULL COMMENT '集成系统中的用户姓名',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_user_id` (`cp_user_id`),
  KEY `outsys_user_id` (`outsys_user_id`)
) COMMENT='通讯录成员与集成系统人员关联表'
;
DROP TABLE IF EXISTS `em_cp_link`
;
CREATE TABLE `em_cp_link` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '所属企业号ID',
  `cp_agent_id` varchar(32) DEFAULT NULL COMMENT '所属企业号应用ID',
  `link_name` varchar(50) DEFAULT NULL COMMENT '链接名称',
  `link_desc` varchar(500) DEFAULT NULL COMMENT '链接描述信息',
  `link_type` tinyint(4) DEFAULT NULL COMMENT '链接类型： 1-应用主页，2-应用菜单，3-普通链接',
  `link_menu_key` varchar(50) DEFAULT NULL COMMENT 'link_type为2时对应的菜单key值',
  `link_menu_pid` varchar(32) DEFAULT NULL COMMENT 'link_type为2时对应的菜单的上级ID',
  `link_action_type` tinyint(4) DEFAULT NULL COMMENT '链接动作类型： 1-打开门户，2-打开应用，3-自定义链接',
  `link_action_setting` varchar(100) DEFAULT NULL COMMENT '链接动作参数值，link_action_type为1时表示门户ID，link_action_type为2时表示应用ID，link_action_type为3时表示自定义链接地址',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_agent_id` (`cp_agent_id`)
) COMMENT='企业号链接功能信息表'
;
DROP TABLE IF EXISTS `em_cp_msg_rule`
;
CREATE TABLE `em_cp_msg_rule` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '所属企业号ID',
  `rule_name` varchar(50) DEFAULT NULL COMMENT '规则名称',
  `rule_desc` varchar(500) DEFAULT NULL COMMENT '规则描述信息',
  `cp_agent_id` varchar(32) DEFAULT NULL COMMENT '推送目标，即企业号应用ID',
  `relate_agent_id` varchar(32) DEFAULT NULL COMMENT '关联的本地消息型应用ID',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_agent_id` (`cp_agent_id`)
) COMMENT='企业号消息推送规则设置表'
;
DROP TABLE IF EXISTS `em_cp_msg_log`
;
CREATE TABLE `em_cp_msg_log` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '所属企业号ID',
  `cp_agent_id` varchar(32) DEFAULT NULL COMMENT '所属企业号应用ID',
  `relate_agent_id` varchar(32) DEFAULT NULL COMMENT '关联的本地消息型应用ID',
  `msg_json` mediumtext DEFAULT NULL COMMENT '消息内容',
  `msg_data_id` varchar(50) DEFAULT NULL COMMENT '消息数据ID',
  `msg_data_type` tinyint(4) DEFAULT NULL COMMENT '消息数据类型',
  `link_url` varchar(500) DEFAULT NULL COMMENT '链接地址',
  `link_url_pc` varchar(500) DEFAULT NULL COMMENT 'PC端链接地址',
  `im_msg_id` mediumtext DEFAULT NULL COMMENT 'IM返回的消息ID',
  `tousers` mediumtext DEFAULT NULL COMMENT '消息接收者',
  `sende_time` datetime DEFAULT NULL COMMENT '发送时间',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_agent_id` (`cp_agent_id`),
  KEY `relate_agent_id` (`relate_agent_id`),
  KEY `msg_data_id` (`msg_data_id`),
  KEY `msg_data_type` (`msg_data_type`),
  KEY `sende_time` (`sende_time`)
) COMMENT='企业号推送消息信息表'
;