DROP TABLE IF EXISTS `em_cp_user_sync_set`
;
CREATE TABLE `em_cp_user_sync_set` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `sys_task_id` varchar(32) DEFAULT NULL COMMENT '定时同步任务ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `sync_type` tinyint(4) DEFAULT 1 COMMENT '同步类型：1-从企业号同步 ，2-从集成系统同步',
  `cp_dept_id` varchar(32) DEFAULT NULL COMMENT '从企业号同步时对应的部门ID，当sync_type为1时需要此值，不设置则为企业号获取到的顶级部门',
  `bind_type` tinyint(4) DEFAULT 0 COMMENT '新成员关联集成系统用户类型：0-不关联，1-自动关联 ，2-手动关联，3-先自动后手动，当sync_type为1时需要此值',
  `root_dept_id` varchar(32) DEFAULT NULL COMMENT '集成系统部门对应的顶级部门ID，即em_cp_dept表主键ID，当sync_type为2时需要此值',
  `add_type` tinyint(4) DEFAULT 1 COMMENT '新成员是否添加到企业号：1-是 ，0-否，当sync_type为2时需要此值',
  `invite_type` tinyint(4) DEFAULT 0 COMMENT '新成员是否邀请加入，主要针对企业微信：1-是 ，0-否，当sync_type为2时需要此值',
  `userid_field` tinyint(4) DEFAULT 1 COMMENT '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号，当sync_type为2时需要此值',
  `user_del_type` tinyint(4) DEFAULT 1 COMMENT '离职成员的处理方式：1-禁用 ，2-删除，当sync_type为2时需要此值',
  `dept_sync_type` tinyint(4) DEFAULT 1 COMMENT '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变，当sync_type为2时需要此值',
  `isalluser` tinyint(4) DEFAULT 0 COMMENT '是否同步无账号人员：0-否 ，1-是，当sync_type为2时需要此值',
  `match_user_field` tinyint(4) DEFAULT 1 COMMENT '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱',
  `match_outsys_field` tinyint(4) DEFAULT 1 COMMENT '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱，5-工号',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `outsys_id` (`outsys_id`)
) COMMENT='企业号通讯录成员同步设置表'
;