DROP TABLE IF EXISTS `em_cp_msg_all`
;
CREATE TABLE `em_cp_msg_all` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '所属企业号ID',
  `cp_agent_id` varchar(32) DEFAULT NULL COMMENT '所属企业号应用ID',
  `relate_agent_id` varchar(32) DEFAULT NULL COMMENT '关联的本地消息型应用ID',
  `msg_json` mediumtext DEFAULT NULL COMMENT '消息内容',
  `msg_data_id` varchar(50) DEFAULT NULL COMMENT '消息数据ID',
  `msg_data_type` tinyint(4) DEFAULT NULL COMMENT '消息数据类型',
  `link_url` varchar(500) DEFAULT NULL COMMENT '链接地址',
  `link_url_pc` varchar(500) DEFAULT NULL COMMENT 'PC端链接地址',
  `im_msg_id` mediumtext DEFAULT NULL COMMENT 'IM返回的消息ID',
  `tousers` mediumtext DEFAULT NULL COMMENT '消息接收者',
  `sende_time` datetime DEFAULT NULL COMMENT '发送时间',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `cp_agent_id` (`cp_agent_id`),
  KEY `relate_agent_id` (`relate_agent_id`),
  KEY `msg_data_id` (`msg_data_id`),
  KEY `msg_data_type` (`msg_data_type`),
  KEY `sende_time` (`sende_time`)
) COMMENT='企业号推送消息所有数据表'
;