DROP TABLE IF EXISTS `em_agent_msg_log_all`
;
CREATE TABLE `em_agent_msg_log_all` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `open_agent_id` int(11) DEFAULT NULL COMMENT '企业应用openid',
  `target_type` tinyint(4) DEFAULT 0 COMMENT '推送目标类型，0-无，1-E-mobile，2-企业号',
  `touser` text DEFAULT NULL COMMENT '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送',
  `toparty` text DEFAULT NULL COMMENT '部门ID列表（包含下级），多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数',
  `todept` text DEFAULT NULL COMMENT '部门ID列表（不包含下级），多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数',
  `totag` text DEFAULT NULL comment '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数',
  `msgtype` varchar(10) DEFAULT NULL comment '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文',
  `safe` tinyint(4) DEFAULT 0 COMMENT '表示是否是保密消息，0表示否，1表示是，默认0',
  `datainfo` text DEFAULT NULL comment '发送数据的详细信息，json格式的完整内容',
  `requsetinfo` text DEFAULT NULL comment '请求数据vo',
  `errcode` int(11) DEFAULT NULL COMMENT '发送结果状态码',
  `errmsg` varchar(1000) DEFAULT NULL COMMENT '错误信息',
  `invaliduser` text DEFAULT NULL COMMENT '无效的成员ID列表',
  `invalidparty` text DEFAULT NULL COMMENT '无效的部门（包含下级）ID列表',
  `invaliddept` text DEFAULT NULL COMMENT '无效的部门（不包含下级）ID列表',
  `invalidtag` text DEFAULT NULL comment '无效的标签ID列表',
  `realityreceivers` mediumtext DEFAULT NULL comment '消息发送实际上所有接收人id表',
  `source_msg_id` varchar(100) DEFAULT NULL COMMENT '消息数据原始ID，接口传入，不传则系统自动生成',
  `server_msg_id` varchar(100) DEFAULT NULL COMMENT '消息数据在消息服务端的ID',
  `send_type` tinyint(4) DEFAULT 0 COMMENT '消息发送类型，1-立即发送，2-定时发送',
  `send_time` datetime DEFAULT NULL COMMENT '消息发送时间，如果为定时发送，这里为定时发送时间',
  `log_group_id` varchar(100) DEFAULT NULL COMMENT '操作批次id',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `open_agent_id` (`open_agent_id`),
  KEY `source_msg_id` (`source_msg_id`),
  KEY `server_msg_id` (`server_msg_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业应用发送消息记录表'
;