CREATE TABLE `em_cp_checkin_sync_set` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `sync_name` varchar(50) DEFAULT NULL COMMENT '同步设置名称',
  `sys_task_id` varchar(32) DEFAULT NULL COMMENT '定时同步任务ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `data_starttime` varchar(50) DEFAULT NULL comment '打卡数据开始时间',
  `data_endtime` varchar(50) DEFAULT NULL comment '打卡数据结束时间',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `outsys_id` (`outsys_id`)
) COMMENT='企业号考勤打卡数据同步设置表'
;
DROP TABLE IF EXISTS `em_cp_checkin_sync_cond`
;
CREATE TABLE `em_cp_checkin_sync_cond` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `cond_type` tinyint(4) DEFAULT NULL COMMENT '条件类型：1-人员，2-部门，3-分部',
  `auth_type` tinyint(4) DEFAULT NULL COMMENT '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人',
  `auth_type_name` varchar(32) DEFAULT NULL COMMENT '规则类型显示名',
  `auth_value` varchar(32) DEFAULT NULL COMMENT '规则类型值',
  `auth_value_name` varchar(32) DEFAULT NULL COMMENT '规则类型值显示名',
  `auth_seclevel` varchar(32) DEFAULT NULL COMMENT '规则安全级别最小值',
  `auth_seclevel_max` varchar(32) DEFAULT NULL COMMENT '规则安全级别最大值',
  `showorder` int(11) DEFAULT NULL COMMENT '显示顺序',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `outsys_id` (`outsys_id`)
) COMMENT='企业号考勤打卡数据同步条件表'
;
DROP TABLE IF EXISTS `em_cp_checkin_sync_state`
;
CREATE TABLE `em_cp_checkin_sync_state` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `sync_state` tinyint(4) DEFAULT NULL COMMENT '同步状态：1-未同步，2-同步中',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号考勤打卡数据同步状态表'
;
DROP TABLE IF EXISTS `em_cp_checkin_sync_log`
;
CREATE TABLE `em_cp_checkin_sync_log` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL comment '企业号基本信息ID',
  `outsys_id` varchar(32) DEFAULT NULL COMMENT '集成系统ID',
  `log_txt` text DEFAULT NULL COMMENT '同步结果',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号考勤打卡数据同步日志记录表'
;