CREATE TABLE `em_sys_sign_setting` (
  `id` varchar(32) NOT NULL,
  `enabled` tinyint(4) DEFAULT NULL COMMENT '是否开启手写签批：0-禁用、1-开启',
  `ios_sign_type` tinyint(4) DEFAULT NULL COMMENT 'IOS签批方式：1-WPS、2-金格office',
  `ios_wps_secret` varchar(500) DEFAULT NULL COMMENT 'IOS WPS秘钥',
  `ios_office_secret` varchar(800) DEFAULT NULL COMMENT 'IOS 金格秘钥',
  `and_sign_type` tinyint(4) DEFAULT NULL COMMENT 'Android签批方式：1-WPS、2-金格office、3-永中office',
  `and_wps_secret` varchar(500) DEFAULT NULL COMMENT 'Android WPS秘钥',
  `and_office_secret` varchar(800) DEFAULT NULL COMMENT 'Android 金格秘钥',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='手写签批设置信息'
;
INSERT INTO `em_sys_sign_setting` VALUES ('1', 0, 1, '', '', 1, '', '', 1, '1', now(), null, null, '1')
;
CREATE TABLE `em_sign_right` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `client_type` tinyint(4) DEFAULT NULL COMMENT '2-IOS客户端，3-安卓客户端',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='手写签批使用权限设置表'
;