CREATE TABLE `em_sys_face_setting` (
  `id` varchar(32) NOT NULL,
  `enabled` tinyint(4) DEFAULT NULL COMMENT '是否开启人脸集成功能：0-禁用、1-开启',
  `api_url` varchar(200) DEFAULT NULL COMMENT '接口地址',
  `app_id` varchar(100) DEFAULT NULL COMMENT '接入的appId',
  `auth_key_id` varchar(100) DEFAULT NULL COMMENT '接入的authKeyID',
  `right_type` tinyint(4) COMMENT '权限类型：1-包含，2-排除',
  `enable_login_verify` tinyint(4) COMMENT '是否开启登录验证：1-是，0-否',
  `verify_range_type` tinyint(4) COMMENT '登录验证范围类型：1-包含，2-排除',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='人脸集成设置信息'
;
INSERT INTO `em_sys_face_setting` VALUES ('1', 0, null, null, null, 1, 0, 1, 1, '1', now(), null, null, '1')
;

CREATE TABLE `em_sys_face_right` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='人脸使用权限设置表'
;


CREATE TABLE `em_sys_face_verify_range` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `hrm_data_id` varchar(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` tinyint(4) DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='人脸登录验证使用范围设置表'
;

CREATE TABLE `em_face_baseuser_photo`  (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) COMMENT '基础用户ID',
  `photo_id` varchar(32) COMMENT '采集照片ID',
  `collect_status` tinyint(4) COMMENT '采集状态：0-未采集，1-成功，2-失败',
  `collect_desc` varchar(500) COMMENT '采集信息描述',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态：1-正常，3-删除',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT = '用户人脸信息记录表'
;