CREATE TABLE em_sys_url_mapping (
  id varchar(32) NOT NULL,
  url_type tinyint(4) DEFAULT NULL COMMENT '地址类型：1-EC、2-APP消息、3-PC消息',
  outsys_id varchar(32) DEFAULT NULL COMMENT '当url_type为1时，表示对应的ecology系统id',
  request_type tinyint(4) DEFAULT NULL COMMENT '请求判断类型：1-根据EM访问地址判断、2-根据客户端IP判断',
  request_param varchar(1000) DEFAULT NULL COMMENT '请求参数，当request_type为1时表示请求的EM地址，当request_type为2时表示客户端的IP，多个IP用分号隔开',
  mapping_url varchar(100) DEFAULT NULL COMMENT '映射的EC系统访问地址',
  mapping_host varchar(100) DEFAULT NULL COMMENT '映射的消息服务地址',
  mapping_port varchar(100) DEFAULT NULL COMMENT '映射的消息服务端口号',
  mapping_encrypt tinyint(4) DEFAULT NULL COMMENT '映射的消息服务连接是否加密',
  priority int(11) COMMENT '优先级，数值越大优先级越高',
  status tinyint(4) DEFAULT 1 COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id)
) COMMENT='系统访问地址映射关系表'
;