DROP TABLE IF EXISTS `em_license_module`
;
CREATE TABLE `em_license_module` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `identification_number` varchar(32) DEFAULT NULL COMMENT '识别码',
  `module` varchar(32) DEFAULT NULL COMMENT '模块名称',
  `count` tinyint(4) DEFAULT NULL COMMENT '集成数量',
  `user_count` int(11) DEFAULT NULL COMMENT '用户数量',
  `user_count_type` tinyint(11) DEFAULT NULL COMMENT '用户数类型，1-并发、2-注册，默认并发',
  `expire_date` datetime DEFAULT NULL COMMENT '过期时间',
  `license_id` varchar(32) DEFAULT NULL COMMENT '关联主license主键',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '最后修改人',
  `update_time` datetime DEFAULT NULL COMMENT '最后修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `identification_number` (`identification_number`),
  KEY `module` (`module`),
  KEY `license_id` (`license_id`)
) COMMENT='服务端License模块信息表'
;
insert into em_license_module select md5(uuid()),identification_number,'em',1,(case when em_user_count is null then user_count else em_user_count end),(case when em_user_count_type is null then 1 else em_user_count_type end),(case when em_expire_date is null then (case when eternal = 1 then null else expire_date end) else em_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where em_count = 1 or em_count = 2
;
insert into em_license_module select md5(uuid()),identification_number,'emPC',1,(case when em_pc_user_count is null then user_count else em_pc_user_count end),(case when em_pc_user_count_type is null then 1 else em_pc_user_count_type end),(case when em_pc_expire_date is null then (case when eternal = 1 then null else expire_date end) else em_pc_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where em_count = 1 or em_count = 3
;
insert into em_license_module select md5(uuid()),identification_number,'cp',1,(case when cp_user_count is null then user_count else cp_user_count end),(case when cp_user_count_type is null then 1 else cp_user_count_type end),(case when cp_expire_date is null then (case when eternal = 1 then null else expire_date end) else cp_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where cp_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'mp',1,(case when mp_user_count is null then user_count else mp_user_count end),(case when mp_user_count_type is null then 1 else mp_user_count_type end),(case when mp_expire_date is null then (case when eternal = 1 then null else expire_date end) else mp_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where mp_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'dd',1,(case when dd_user_count is null then user_count else dd_user_count end),(case when dd_user_count_type is null then 1 else dd_user_count_type end),(case when dd_expire_date is null then (case when eternal = 1 then null else expire_date end) else dd_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where dd_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'lx',1,(case when lx_user_count is null then user_count else lx_user_count end),(case when lx_user_count_type is null then 1 else lx_user_count_type end),(case when lx_expire_date is null then (case when eternal = 1 then null else expire_date end) else lx_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where lx_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'gzb',1,(case when gzb_user_count is null then user_count else gzb_user_count end),(case when gzb_user_count_type is null then 1 else gzb_user_count_type end),(case when gzb_expire_date is null then (case when eternal = 1 then null else expire_date end) else gzb_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where gzb_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'jdyzj',1,(case when jdyzj_user_count is null then user_count else jdyzj_user_count end),(case when jdyzj_user_count_type is null then 1 else jdyzj_user_count_type end),(case when jdyzj_expire_date is null then (case when eternal = 1 then null else expire_date end) else jdyzj_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where jdyzj_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'hfx',1,(case when hfx_user_count is null then user_count else hfx_user_count end),(case when hfx_user_count_type is null then 1 else hfx_user_count_type end),(case when hfx_expire_date is null then (case when eternal = 1 then null else expire_date end) else hfx_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where hfx_count = 1
;
insert into em_license_module select md5(uuid()),identification_number,'fxxk',1,(case when fxxk_user_count is null then user_count else fxxk_user_count end),(case when fxxk_user_count_type is null then 1 else fxxk_user_count_type end),(case when fxxk_expire_date is null then (case when eternal = 1 then null else expire_date end) else fxxk_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where fxxk_count = 1
;