CREATE TABLE `em_cp_tag` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '企业号基本信息ID',
  `open_tag_id` varchar(100) DEFAULT NULL COMMENT '公众号标签ID',
  `tag_name` varchar(100) DEFAULT NULL COMMENT '标签名称',
  `user_amount` int(11) DEFAULT NULL COMMENT '标签用户数',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号通讯录标签表'
;

CREATE TABLE `em_cp_tag_user` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_tag_id` varchar(32) DEFAULT NULL COMMENT '通讯录标签表ID',
  `cp_user_id` varchar(32) DEFAULT NULL COMMENT '通讯录人员表ID',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号通讯录标签与成员关联表'
;
