CREATE TABLE `em_sys_clienttask_setting`  (
  `id` VARCHAR(32) NOT NULL COMMENT '主键',
  `task_type` TINYINT DEFAULT NULL COMMENT '任务类型：1-上报活跃、2-上报定位、3-上报步数、4-请求弹窗',
  `task_cycle` INT COMMENT '任务执行周期，单位为秒',
  `task_time_type` TINYINT COMMENT '任务执行时间类型，1-所有时间、2-指定时间段',
  `task_time_start` VARCHAR(20) COMMENT '任务执行指定时间段的开始时间',
  `task_time_end` VARCHAR(20) COMMENT '任务执行指定时间段的结束时间',
  `task_range_type` TINYINT COMMENT '任务执行适用范围类型：1-包含，2-排除',
  `status` TINYINT DEFAULT NULL COMMENT '状态：1-正常，2-禁用，3-删除',
  `create_time` DATETIME DEFAULT NULL COMMENT '创建时间',
  `create_user_id` VARCHAR(32) DEFAULT NULL COMMENT '创建人',
  `update_time` DATETIME DEFAULT NULL COMMENT '修改时间',
  `update_user_id` VARCHAR(32) DEFAULT NULL COMMENT '修改人',
  `tenant_id` VARCHAR(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT = '客户端定时任务设置表'
;

CREATE TABLE `em_sys_clienttask_right` (
  `id` VARCHAR(32) NOT NULL COMMENT '主键ID',
  `task_id` VARCHAR(32)  DEFAULT NULL COMMENT '对应任务id',
  `hrm_data_id` VARCHAR(32) DEFAULT NULL COMMENT '通讯录成员或部门表ID',
  `hrm_data_type` TINYINT DEFAULT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）',
  `status` TINYINT DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` VARCHAR(32) DEFAULT NULL COMMENT '创建人',
  `create_time` DATETIME DEFAULT NULL COMMENT '创建时间',
  `update_user_id` VARCHAR(32) DEFAULT NULL COMMENT '修改人',
  `update_time` DATETIME DEFAULT NULL COMMENT '修改时间',
  `tenant_id` VARCHAR(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `hrm_data_id` (`hrm_data_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='客户端定时任务使用权限设置表'
;

CREATE TABLE `em_sys_baseuser_location`  ( 
  `id` VARCHAR(32) NOT NULL COMMENT '主键',
  `client_type` TINYINT DEFAULT 0 COMMENT '设备类型：1-PC客户端，2-ios，3-android，4-web',
  `device_id` VARCHAR(500) COMMENT '设备标识',
  `longitude` VARCHAR(100) COMMENT '经度',
  `latitude` VARCHAR(100) COMMENT '纬度',
  `status` INT DEFAULT NULL COMMENT '状态：1-正常，3-删除',
  `create_time` DATETIME DEFAULT NULL COMMENT '创建时间',
  `create_user_id` VARCHAR(32) DEFAULT NULL COMMENT '创建人',
  `update_time` DATETIME DEFAULT NULL COMMENT '修改时间',
  `update_user_id` VARCHAR(32) DEFAULT NULL COMMENT '修改人',
  `tenant_id` VARCHAR(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT = '用户定位信息记录表'
;
