ALTER TABLE em_log_access RENAME TO em_log_access_bak
;
DROP TABLE IF EXISTS `em_log_access`
;
CREATE TABLE `em_log_access` (
  `id` VARCHAR(32) NOT NULL COMMENT '主键',
  `base_user_id` VARCHAR(32) DEFAULT NULL COMMENT '用户ID',
  `base_user_name` VARCHAR(255) DEFAULT NULL COMMENT '用户名',
  `base_user_status` TINYINT DEFAULT NULL COMMENT '用户状态 1-已注册，2-未注册，3-删除',
  `operation` VARCHAR(255) DEFAULT NULL COMMENT '操作：login-登录，logout-登出',
  `access_token` VARCHAR(100) DEFAULT NULL COMMENT '访问token',
  `login_type` TINYINT DEFAULT NULL COMMENT '登录类型：1-客户端，2-管理端，3-接口',
  `login_mode` TINYINT DEFAULT NULL COMMENT '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录',
  `client_type` TINYINT DEFAULT NULL COMMENT '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版',
  `client_version` VARCHAR(50) DEFAULT NULL COMMENT '客户端版本',
  `device_id` VARCHAR(255) DEFAULT NULL COMMENT '客户端硬件标识',
  	lang_type VARCHAR(20) COMMENT '语言类型' , 
  	os_version VARCHAR(800) COMMENT '客户端操作系统版本',
  	client_model VARCHAR(100) COMMENT '客户端设备型号',
  `ip` VARCHAR(255) DEFAULT NULL COMMENT 'IP地址',
  `user_agent` VARCHAR(500) DEFAULT NULL COMMENT '访问头信息',
  `create_time` DATETIME DEFAULT NULL COMMENT '日志创建时间',
  `tenant_id` VARCHAR(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `access_token` (`access_token`),
  KEY `base_user_id` (`base_user_id`),
  KEY `create_time` (`create_time`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='访问日志'
;
